<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="Description" content="">
    <meta name="Author" content="Vdoconference">
    <link rel="icon" href="{{ asset('assets/images/logo.png') }}" type="image/x-icon" />
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <input type="hidden" id="csrf-token" value="{{ csrf_token() }}">
    <meta name="Keywords" content="" />
    <title>Vdoconference | Register</title>
    @include('includes.admin.head')

    <!-- Meta Data -->
    {{-- <meta property='og:title' content={{ $event->name }} />
   <meta property='og:image' content="{{ $cover }}" />
   <meta property='og:description' content="{{ $event->name }} Registration" />
   <meta property='og:url' content={{ url($event->event_code ?? 'new-user') }} /> --}}

    <style>
        .registration-link-div {
            text-align: center;
            display: flex;
            flex-direction: column;
            align-items: center;
        }

        .registration-link-div img {
            height: 70px;
            text-align: center;
            width: 210px;
        }

        .registration-link-div span {
            text-align: center;
            font-size: 14px;
            margin-top: 5px
        }

        .registration-link-p {
            text-align: center;
            font-size: 26px;
            font-weight: 600;
        }

        .event-image-div {
            position: relative;
            width: fit-content;
        }

        .event_form_class {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            opacity: 0;
            cursor: pointer;
            z-index: 1;
        }

        .event_form_class+img {
            /* opacity: 0.5; */
            border-radius: 20px;
        }

        .event_form_class:checked+img {
            opacity: 1;
            border: 5px solid #f1b600;
            -webkit-box-shadow: 0px 0px 14px 8px rgba(0, 0, 0, 0.31);
            -moz-box-shadow: 0px 0px 14px 8px rgba(0, 0, 0, 0.31);
            box-shadow: 0px 0px 14px 8px rgba(0, 0, 0, 0.31);
            background: white;
            padding: 5px;
            border-radius: 20px;

        }

        form * {
            font-size: 19px !important;
        }

        form label {
            font-weight: bolder !important;
            color: black;
        }

        body {
            background-color: white !important;
        }

        .form-control::-webkit-input-placeholder,
        .form-select::-webkit-input-placeholder {
            color: black;
        }

        @media only screen and (max-device-width: 768px) {

            .form-control,
            .form-select {
                padding: 17px 18px;
                font-size: 31.2px !important;
                font-weight: 400;
                margin-bottom: 12px;
            }

            form label {
                font-size: 29.2px !important
            }

            .btn {
                padding: 17px 18px;
                font-size: 31.2px !important;
                font-weight: 400;
            }
        }

        .select2-drop .select2-container .select2-selection--single,
        .select2-drop .select2-container .select2-selection--single .select2-selection__arrow {
            height: 45px !important;
        }

        .select2-drop .select2-container .select2-selection--single .select2-selection__rendered {
            line-height: 45px !important;
        }

        .coupon-code-div {
            display: flex;
            gap: 10px;
        }

        .coupon-code-div input {
            width: 80%;
        }

        .coupon-code-div button {
            flex-grow: 1;
        }
    </style>

    <style>
        .visitor-img {
            position: relative;
        }

        .visito-btn {
            position: absolute;
            right: 2%;
            font-size: 24px;
            top: 101%;
            padding: 13px 15px;
            border-radius: 4px;
            background: #17459d;
            color: #FFF !important;
        }

        .swiper {
            width: 100%;
            height: 100%;
        }

        .swiper-slide {
            text-align: center;
            font-size: 18px;
            background: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .swiper-slide img {
            display: block;
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
    </style>
</head>

<body style="background-color: #d1d1d1">

    @include('includes.admin.footer')

    <div id="layout-wrapper">
        <div class="w-100 align-content-center">
            <div class="visitor-img">
                <img class="" src="https://cdn.mygrid.club/media/4buUfHLvDbzo7TUXeFkjqChNexSEohZHe0HrjNEX.png"
                    alt="Max-width 100%" style="width: 100%;">
            </div>
        </div>

        <div class="container p-5">
            <div class="member_registrations event_form_div">
                <form class="custom-validation" method="post" action="http://grid.local/event-register"
                    enctype="multipart/form-data">
                    <input type="hidden" name="_token" value="cjLGwg1DZhF90GK80HBUe8dsSiwHl9W6mT9fvwEk">
                    <input type="hidden" name="event_form" value="Member registrations">
                    <input type="hidden" name="form_id" value="24">
                    <div class="form-group pt-4 name">
                        <div class="row">
                            <label for="name">Your name (mandatory)</label>
                            <div class="col-12">
                                <input class="form-control name name-0" type="text" placeholder="Your name*"
                                    value="" id="name-0" name="name" required />

                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4 designation">
                        <div class="row">
                            <label for="designation">Your business category like - Dentist, Cement Dealer, Architect,
                                Graphic Designer (mandatory)</label>
                            <div class="col-12">
                                <input class="form-control designation designation-0" type="text"
                                    placeholder="Your business category*" value="" id="designation-0"
                                    name="designation" required />

                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4 email">
                        <div class="row">
                            <label for="email">Email (mandatory)</label>
                            <div class="col-12">
                                <input class="form-control email email-0" type="text" placeholder="Email*"
                                    value="" id="email-0" name="email"
                                    pattern="[a-z0-9._%+\-]+@[a-z0-9.\-]+\.[a-z]{2,}$" oninput="validateEmail(0)"
                                    onchange="checkEmail(this)" required />

                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4 contact">
                        <div class="row">
                            <label for="contact">Contact (mandatory) (Please enter your mobile number in 10 digits
                                without space)</label>
                            <div class="col-3">
                                <div class="select2-drop">
                                    <select id="countrySelect-0" class="form-select countrySelect-0 select2"
                                        onchange="updateStates('0')" name="country_code" style="width: 100%;">
                                        <option value="">Select a country </option>
                                        <option data-countryCode="IN" value="+91" selected="selected">
                                            india (+91)
                                        </option>
                                        <option data-countryCode="AF" value="+93">
                                            Afghanistan (+93)
                                        </option>
                                        <option data-countryCode="AX" value="+358-18">
                                            Aland Islands (+358-18)
                                        </option>
                                        <option data-countryCode="AL" value="+355">
                                            Albania (+355)
                                        </option>
                                        <option data-countryCode="DZ" value="+213">
                                            Algeria (+213)
                                        </option>
                                        <option data-countryCode="AS" value="+1-684">
                                            American Samoa (+1-684)
                                        </option>
                                        <option data-countryCode="AD" value="+376">
                                            Andorra (+376)
                                        </option>
                                        <option data-countryCode="AO" value="+244">
                                            Angola (+244)
                                        </option>
                                        <option data-countryCode="AI" value="+1-264">
                                            Anguilla (+1-264)
                                        </option>
                                        <option data-countryCode="AQ" value="+672">
                                            Antarctica (+672)
                                        </option>
                                        <option data-countryCode="AG" value="+1-268">
                                            Antigua and Barbuda (+1-268)
                                        </option>
                                        <option data-countryCode="AR" value="+54">
                                            Argentina (+54)
                                        </option>
                                        <option data-countryCode="AM" value="+374">
                                            Armenia (+374)
                                        </option>
                                        <option data-countryCode="AW" value="+297">
                                            Aruba (+297)
                                        </option>
                                        <option data-countryCode="AU" value="+61">
                                            Australia (+61)
                                        </option>
                                        <option data-countryCode="AT" value="+43">
                                            Austria (+43)
                                        </option>
                                        <option data-countryCode="AZ" value="+994">
                                            Azerbaijan (+994)
                                        </option>
                                        <option data-countryCode="BH" value="+973">
                                            Bahrain (+973)
                                        </option>
                                        <option data-countryCode="BD" value="+880">
                                            Bangladesh (+880)
                                        </option>
                                        <option data-countryCode="BB" value="+1-246">
                                            Barbados (+1-246)
                                        </option>
                                        <option data-countryCode="BY" value="+375">
                                            Belarus (+375)
                                        </option>
                                        <option data-countryCode="BE" value="+32">
                                            Belgium (+32)
                                        </option>
                                        <option data-countryCode="BZ" value="+501">
                                            Belize (+501)
                                        </option>
                                        <option data-countryCode="BJ" value="+229">
                                            Benin (+229)
                                        </option>
                                        <option data-countryCode="BM" value="+1-441">
                                            Bermuda (+1-441)
                                        </option>
                                        <option data-countryCode="BT" value="+975">
                                            Bhutan (+975)
                                        </option>
                                        <option data-countryCode="BO" value="+591">
                                            Bolivia (+591)
                                        </option>
                                        <option data-countryCode="BQ" value="+599">
                                            Bonaire, Sint Eustatius and Saba (+599)
                                        </option>
                                        <option data-countryCode="BA" value="+387">
                                            Bosnia and Herzegovina (+387)
                                        </option>
                                        <option data-countryCode="BW" value="+267">
                                            Botswana (+267)
                                        </option>
                                        <option data-countryCode="BV" value="+0055">
                                            Bouvet Island (+0055)
                                        </option>
                                        <option data-countryCode="BR" value="+55">
                                            Brazil (+55)
                                        </option>
                                        <option data-countryCode="IO" value="+246">
                                            British Indian Ocean Territory (+246)
                                        </option>
                                        <option data-countryCode="BN" value="+673">
                                            Brunei (+673)
                                        </option>
                                        <option data-countryCode="BG" value="+359">
                                            Bulgaria (+359)
                                        </option>
                                        <option data-countryCode="BF" value="+226">
                                            Burkina Faso (+226)
                                        </option>
                                        <option data-countryCode="BI" value="+257">
                                            Burundi (+257)
                                        </option>
                                        <option data-countryCode="KH" value="+855">
                                            Cambodia (+855)
                                        </option>
                                        <option data-countryCode="CM" value="+237">
                                            Cameroon (+237)
                                        </option>
                                        <option data-countryCode="CA" value="+1">
                                            Canada (+1)
                                        </option>
                                        <option data-countryCode="CV" value="+238">
                                            Cape Verde (+238)
                                        </option>
                                        <option data-countryCode="KY" value="+1-345">
                                            Cayman Islands (+1-345)
                                        </option>
                                        <option data-countryCode="CF" value="+236">
                                            Central African Republic (+236)
                                        </option>
                                        <option data-countryCode="TD" value="+235">
                                            Chad (+235)
                                        </option>
                                        <option data-countryCode="CL" value="+56">
                                            Chile (+56)
                                        </option>
                                        <option data-countryCode="CN" value="+86">
                                            China (+86)
                                        </option>
                                        <option data-countryCode="CX" value="+61">
                                            Christmas Island (+61)
                                        </option>
                                        <option data-countryCode="CC" value="+61">
                                            Cocos (Keeling) Islands (+61)
                                        </option>
                                        <option data-countryCode="CO" value="+57">
                                            Colombia (+57)
                                        </option>
                                        <option data-countryCode="KM" value="+269">
                                            Comoros (+269)
                                        </option>
                                        <option data-countryCode="CG" value="+242">
                                            Congo (+242)
                                        </option>
                                        <option data-countryCode="CK" value="+682">
                                            Cook Islands (+682)
                                        </option>
                                        <option data-countryCode="CR" value="+506">
                                            Costa Rica (+506)
                                        </option>
                                        <option data-countryCode="CI" value="+225">
                                            Cote D&#039;Ivoire (Ivory Coast) (+225)
                                        </option>
                                        <option data-countryCode="HR" value="+385">
                                            Croatia (+385)
                                        </option>
                                        <option data-countryCode="CU" value="+53">
                                            Cuba (+53)
                                        </option>
                                        <option data-countryCode="CW" value="+599">
                                            Curaçao (+599)
                                        </option>
                                        <option data-countryCode="CY" value="+357">
                                            Cyprus (+357)
                                        </option>
                                        <option data-countryCode="CZ" value="+420">
                                            Czech Republic (+420)
                                        </option>
                                        <option data-countryCode="CD" value="+243">
                                            Democratic Republic of the Congo (+243)
                                        </option>
                                        <option data-countryCode="DK" value="+45">
                                            Denmark (+45)
                                        </option>
                                        <option data-countryCode="DJ" value="+253">
                                            Djibouti (+253)
                                        </option>
                                        <option data-countryCode="DM" value="+1-767">
                                            Dominica (+1-767)
                                        </option>
                                        <option data-countryCode="DO" value="+1-809 and 1-829">
                                            Dominican Republic (+1-809 and 1-829)
                                        </option>
                                        <option data-countryCode="EC" value="+593">
                                            Ecuador (+593)
                                        </option>
                                        <option data-countryCode="EG" value="+20">
                                            Egypt (+20)
                                        </option>
                                        <option data-countryCode="SV" value="+503">
                                            El Salvador (+503)
                                        </option>
                                        <option data-countryCode="GQ" value="+240">
                                            Equatorial Guinea (+240)
                                        </option>
                                        <option data-countryCode="ER" value="+291">
                                            Eritrea (+291)
                                        </option>
                                        <option data-countryCode="EE" value="+372">
                                            Estonia (+372)
                                        </option>
                                        <option data-countryCode="SZ" value="+268">
                                            Eswatini (+268)
                                        </option>
                                        <option data-countryCode="ET" value="+251">
                                            Ethiopia (+251)
                                        </option>
                                        <option data-countryCode="FK" value="+500">
                                            Falkland Islands (+500)
                                        </option>
                                        <option data-countryCode="FO" value="+298">
                                            Faroe Islands (+298)
                                        </option>
                                        <option data-countryCode="FJ" value="+679">
                                            Fiji Islands (+679)
                                        </option>
                                        <option data-countryCode="FI" value="+358">
                                            Finland (+358)
                                        </option>
                                        <option data-countryCode="FR" value="+33">
                                            France (+33)
                                        </option>
                                        <option data-countryCode="GF" value="+594">
                                            French Guiana (+594)
                                        </option>
                                        <option data-countryCode="PF" value="+689">
                                            French Polynesia (+689)
                                        </option>
                                        <option data-countryCode="TF" value="+262">
                                            French Southern Territories (+262)
                                        </option>
                                        <option data-countryCode="GA" value="+241">
                                            Gabon (+241)
                                        </option>
                                        <option data-countryCode="GM" value="+220">
                                            Gambia The (+220)
                                        </option>
                                        <option data-countryCode="GE" value="+995">
                                            Georgia (+995)
                                        </option>
                                        <option data-countryCode="DE" value="+49">
                                            Germany (+49)
                                        </option>
                                        <option data-countryCode="GH" value="+233">
                                            Ghana (+233)
                                        </option>
                                        <option data-countryCode="GI" value="+350">
                                            Gibraltar (+350)
                                        </option>
                                        <option data-countryCode="GR" value="+30">
                                            Greece (+30)
                                        </option>
                                        <option data-countryCode="GL" value="+299">
                                            Greenland (+299)
                                        </option>
                                        <option data-countryCode="GD" value="+1-473">
                                            Grenada (+1-473)
                                        </option>
                                        <option data-countryCode="GP" value="+590">
                                            Guadeloupe (+590)
                                        </option>
                                        <option data-countryCode="GU" value="+1-671">
                                            Guam (+1-671)
                                        </option>
                                        <option data-countryCode="GT" value="+502">
                                            Guatemala (+502)
                                        </option>
                                        <option data-countryCode="GG" value="+44-1481">
                                            Guernsey and Alderney (+44-1481)
                                        </option>
                                        <option data-countryCode="GN" value="+224">
                                            Guinea (+224)
                                        </option>
                                        <option data-countryCode="GW" value="+245">
                                            Guinea-Bissau (+245)
                                        </option>
                                        <option data-countryCode="GY" value="+592">
                                            Guyana (+592)
                                        </option>
                                        <option data-countryCode="HT" value="+509">
                                            Haiti (+509)
                                        </option>
                                        <option data-countryCode="HM" value="+672">
                                            Heard Island and McDonald Islands (+672)
                                        </option>
                                        <option data-countryCode="HN" value="+504">
                                            Honduras (+504)
                                        </option>
                                        <option data-countryCode="HK" value="+852">
                                            Hong Kong S.A.R. (+852)
                                        </option>
                                        <option data-countryCode="HU" value="+36">
                                            Hungary (+36)
                                        </option>
                                        <option data-countryCode="IS" value="+354">
                                            Iceland (+354)
                                        </option>
                                        <option data-countryCode="ID" value="+62">
                                            Indonesia (+62)
                                        </option>
                                        <option data-countryCode="IR" value="+98">
                                            Iran (+98)
                                        </option>
                                        <option data-countryCode="IQ" value="+964">
                                            Iraq (+964)
                                        </option>
                                        <option data-countryCode="IE" value="+353">
                                            Ireland (+353)
                                        </option>
                                        <option data-countryCode="IL" value="+972">
                                            Israel (+972)
                                        </option>
                                        <option data-countryCode="IT" value="+39">
                                            Italy (+39)
                                        </option>
                                        <option data-countryCode="JM" value="+1-876">
                                            Jamaica (+1-876)
                                        </option>
                                        <option data-countryCode="JP" value="+81">
                                            Japan (+81)
                                        </option>
                                        <option data-countryCode="JE" value="+44-1534">
                                            Jersey (+44-1534)
                                        </option>
                                        <option data-countryCode="JO" value="+962">
                                            Jordan (+962)
                                        </option>
                                        <option data-countryCode="KZ" value="+7">
                                            Kazakhstan (+7)
                                        </option>
                                        <option data-countryCode="KE" value="+254">
                                            Kenya (+254)
                                        </option>
                                        <option data-countryCode="KI" value="+686">
                                            Kiribati (+686)
                                        </option>
                                        <option data-countryCode="XK" value="+383">
                                            Kosovo (+383)
                                        </option>
                                        <option data-countryCode="KW" value="+965">
                                            Kuwait (+965)
                                        </option>
                                        <option data-countryCode="KG" value="+996">
                                            Kyrgyzstan (+996)
                                        </option>
                                        <option data-countryCode="LA" value="+856">
                                            Laos (+856)
                                        </option>
                                        <option data-countryCode="LV" value="+371">
                                            Latvia (+371)
                                        </option>
                                        <option data-countryCode="LB" value="+961">
                                            Lebanon (+961)
                                        </option>
                                        <option data-countryCode="LS" value="+266">
                                            Lesotho (+266)
                                        </option>
                                        <option data-countryCode="LR" value="+231">
                                            Liberia (+231)
                                        </option>
                                        <option data-countryCode="LY" value="+218">
                                            Libya (+218)
                                        </option>
                                        <option data-countryCode="LI" value="+423">
                                            Liechtenstein (+423)
                                        </option>
                                        <option data-countryCode="LT" value="+370">
                                            Lithuania (+370)
                                        </option>
                                        <option data-countryCode="LU" value="+352">
                                            Luxembourg (+352)
                                        </option>
                                        <option data-countryCode="MO" value="+853">
                                            Macau S.A.R. (+853)
                                        </option>
                                        <option data-countryCode="MG" value="+261">
                                            Madagascar (+261)
                                        </option>
                                        <option data-countryCode="MW" value="+265">
                                            Malawi (+265)
                                        </option>
                                        <option data-countryCode="MY" value="+60">
                                            Malaysia (+60)
                                        </option>
                                        <option data-countryCode="MV" value="+960">
                                            Maldives (+960)
                                        </option>
                                        <option data-countryCode="ML" value="+223">
                                            Mali (+223)
                                        </option>
                                        <option data-countryCode="MT" value="+356">
                                            Malta (+356)
                                        </option>
                                        <option data-countryCode="IM" value="+44-1624">
                                            Man (Isle of) (+44-1624)
                                        </option>
                                        <option data-countryCode="MH" value="+692">
                                            Marshall Islands (+692)
                                        </option>
                                        <option data-countryCode="MQ" value="+596">
                                            Martinique (+596)
                                        </option>
                                        <option data-countryCode="MR" value="+222">
                                            Mauritania (+222)
                                        </option>
                                        <option data-countryCode="MU" value="+230">
                                            Mauritius (+230)
                                        </option>
                                        <option data-countryCode="YT" value="+262">
                                            Mayotte (+262)
                                        </option>
                                        <option data-countryCode="MX" value="+52">
                                            Mexico (+52)
                                        </option>
                                        <option data-countryCode="FM" value="+691">
                                            Micronesia (+691)
                                        </option>
                                        <option data-countryCode="MD" value="+373">
                                            Moldova (+373)
                                        </option>
                                        <option data-countryCode="MC" value="+377">
                                            Monaco (+377)
                                        </option>
                                        <option data-countryCode="MN" value="+976">
                                            Mongolia (+976)
                                        </option>
                                        <option data-countryCode="ME" value="+382">
                                            Montenegro (+382)
                                        </option>
                                        <option data-countryCode="MS" value="+1-664">
                                            Montserrat (+1-664)
                                        </option>
                                        <option data-countryCode="MA" value="+212">
                                            Morocco (+212)
                                        </option>
                                        <option data-countryCode="MZ" value="+258">
                                            Mozambique (+258)
                                        </option>
                                        <option data-countryCode="MM" value="+95">
                                            Myanmar (+95)
                                        </option>
                                        <option data-countryCode="NA" value="+264">
                                            Namibia (+264)
                                        </option>
                                        <option data-countryCode="NR" value="+674">
                                            Nauru (+674)
                                        </option>
                                        <option data-countryCode="NP" value="+977">
                                            Nepal (+977)
                                        </option>
                                        <option data-countryCode="NL" value="+31">
                                            Netherlands (+31)
                                        </option>
                                        <option data-countryCode="NC" value="+687">
                                            New Caledonia (+687)
                                        </option>
                                        <option data-countryCode="NZ" value="+64">
                                            New Zealand (+64)
                                        </option>
                                        <option data-countryCode="NI" value="+505">
                                            Nicaragua (+505)
                                        </option>
                                        <option data-countryCode="NE" value="+227">
                                            Niger (+227)
                                        </option>
                                        <option data-countryCode="NG" value="+234">
                                            Nigeria (+234)
                                        </option>
                                        <option data-countryCode="NU" value="+683">
                                            Niue (+683)
                                        </option>
                                        <option data-countryCode="NF" value="+672">
                                            Norfolk Island (+672)
                                        </option>
                                        <option data-countryCode="KP" value="+850">
                                            North Korea (+850)
                                        </option>
                                        <option data-countryCode="MK" value="+389">
                                            North Macedonia (+389)
                                        </option>
                                        <option data-countryCode="MP" value="+1-670">
                                            Northern Mariana Islands (+1-670)
                                        </option>
                                        <option data-countryCode="NO" value="+47">
                                            Norway (+47)
                                        </option>
                                        <option data-countryCode="OM" value="+968">
                                            Oman (+968)
                                        </option>
                                        <option data-countryCode="PK" value="+92">
                                            Pakistan (+92)
                                        </option>
                                        <option data-countryCode="PW" value="+680">
                                            Palau (+680)
                                        </option>
                                        <option data-countryCode="PS" value="+970">
                                            Palestinian Territory Occupied (+970)
                                        </option>
                                        <option data-countryCode="PA" value="+507">
                                            Panama (+507)
                                        </option>
                                        <option data-countryCode="PG" value="+675">
                                            Papua New Guinea (+675)
                                        </option>
                                        <option data-countryCode="PY" value="+595">
                                            Paraguay (+595)
                                        </option>
                                        <option data-countryCode="PE" value="+51">
                                            Peru (+51)
                                        </option>
                                        <option data-countryCode="PH" value="+63">
                                            Philippines (+63)
                                        </option>
                                        <option data-countryCode="PN" value="+870">
                                            Pitcairn Island (+870)
                                        </option>
                                        <option data-countryCode="PL" value="+48">
                                            Poland (+48)
                                        </option>
                                        <option data-countryCode="PT" value="+351">
                                            Portugal (+351)
                                        </option>
                                        <option data-countryCode="PR" value="+1-787 and 1-939">
                                            Puerto Rico (+1-787 and 1-939)
                                        </option>
                                        <option data-countryCode="QA" value="+974">
                                            Qatar (+974)
                                        </option>
                                        <option data-countryCode="RE" value="+262">
                                            Reunion (+262)
                                        </option>
                                        <option data-countryCode="RO" value="+40">
                                            Romania (+40)
                                        </option>
                                        <option data-countryCode="RU" value="+7">
                                            Russia (+7)
                                        </option>
                                        <option data-countryCode="RW" value="+250">
                                            Rwanda (+250)
                                        </option>
                                        <option data-countryCode="SH" value="+290">
                                            Saint Helena (+290)
                                        </option>
                                        <option data-countryCode="KN" value="+1-869">
                                            Saint Kitts and Nevis (+1-869)
                                        </option>
                                        <option data-countryCode="LC" value="+1-758">
                                            Saint Lucia (+1-758)
                                        </option>
                                        <option data-countryCode="PM" value="+508">
                                            Saint Pierre and Miquelon (+508)
                                        </option>
                                        <option data-countryCode="VC" value="+1-784">
                                            Saint Vincent and the Grenadines (+1-784)
                                        </option>
                                        <option data-countryCode="BL" value="+590">
                                            Saint-Barthelemy (+590)
                                        </option>
                                        <option data-countryCode="MF" value="+590">
                                            Saint-Martin (French part) (+590)
                                        </option>
                                        <option data-countryCode="WS" value="+685">
                                            Samoa (+685)
                                        </option>
                                        <option data-countryCode="SM" value="+378">
                                            San Marino (+378)
                                        </option>
                                        <option data-countryCode="ST" value="+239">
                                            Sao Tome and Principe (+239)
                                        </option>
                                        <option data-countryCode="SA" value="+966">
                                            Saudi Arabia (+966)
                                        </option>
                                        <option data-countryCode="SN" value="+221">
                                            Senegal (+221)
                                        </option>
                                        <option data-countryCode="RS" value="+381">
                                            Serbia (+381)
                                        </option>
                                        <option data-countryCode="SC" value="+248">
                                            Seychelles (+248)
                                        </option>
                                        <option data-countryCode="SL" value="+232">
                                            Sierra Leone (+232)
                                        </option>
                                        <option data-countryCode="SG" value="+65">
                                            Singapore (+65)
                                        </option>
                                        <option data-countryCode="SX" value="+1721">
                                            Sint Maarten (Dutch part) (+1721)
                                        </option>
                                        <option data-countryCode="SK" value="+421">
                                            Slovakia (+421)
                                        </option>
                                        <option data-countryCode="SI" value="+386">
                                            Slovenia (+386)
                                        </option>
                                        <option data-countryCode="SB" value="+677">
                                            Solomon Islands (+677)
                                        </option>
                                        <option data-countryCode="SO" value="+252">
                                            Somalia (+252)
                                        </option>
                                        <option data-countryCode="ZA" value="+27">
                                            South Africa (+27)
                                        </option>
                                        <option data-countryCode="GS" value="+500">
                                            South Georgia (+500)
                                        </option>
                                        <option data-countryCode="KR" value="+82">
                                            South Korea (+82)
                                        </option>
                                        <option data-countryCode="SS" value="+211">
                                            South Sudan (+211)
                                        </option>
                                        <option data-countryCode="ES" value="+34">
                                            Spain (+34)
                                        </option>
                                        <option data-countryCode="LK" value="+94">
                                            Sri Lanka (+94)
                                        </option>
                                        <option data-countryCode="SD" value="+249">
                                            Sudan (+249)
                                        </option>
                                        <option data-countryCode="SR" value="+597">
                                            Suriname (+597)
                                        </option>
                                        <option data-countryCode="SJ" value="+47">
                                            Svalbard and Jan Mayen Islands (+47)
                                        </option>
                                        <option data-countryCode="SE" value="+46">
                                            Sweden (+46)
                                        </option>
                                        <option data-countryCode="CH" value="+41">
                                            Switzerland (+41)
                                        </option>
                                        <option data-countryCode="SY" value="+963">
                                            Syria (+963)
                                        </option>
                                        <option data-countryCode="TW" value="+886">
                                            Taiwan (+886)
                                        </option>
                                        <option data-countryCode="TJ" value="+992">
                                            Tajikistan (+992)
                                        </option>
                                        <option data-countryCode="TZ" value="+255">
                                            Tanzania (+255)
                                        </option>
                                        <option data-countryCode="TH" value="+66">
                                            Thailand (+66)
                                        </option>
                                        <option data-countryCode="BS" value="+1-242">
                                            The Bahamas (+1-242)
                                        </option>
                                        <option data-countryCode="TL" value="+670">
                                            Timor-Leste (+670)
                                        </option>
                                        <option data-countryCode="TG" value="+228">
                                            Togo (+228)
                                        </option>
                                        <option data-countryCode="TK" value="+690">
                                            Tokelau (+690)
                                        </option>
                                        <option data-countryCode="TO" value="+676">
                                            Tonga (+676)
                                        </option>
                                        <option data-countryCode="TT" value="+1-868">
                                            Trinidad and Tobago (+1-868)
                                        </option>
                                        <option data-countryCode="TN" value="+216">
                                            Tunisia (+216)
                                        </option>
                                        <option data-countryCode="TR" value="+90">
                                            Turkey (+90)
                                        </option>
                                        <option data-countryCode="TM" value="+993">
                                            Turkmenistan (+993)
                                        </option>
                                        <option data-countryCode="TC" value="+1-649">
                                            Turks and Caicos Islands (+1-649)
                                        </option>
                                        <option data-countryCode="TV" value="+688">
                                            Tuvalu (+688)
                                        </option>
                                        <option data-countryCode="UG" value="+256">
                                            Uganda (+256)
                                        </option>
                                        <option data-countryCode="UA" value="+380">
                                            Ukraine (+380)
                                        </option>
                                        <option data-countryCode="AE" value="+971">
                                            United Arab Emirates (+971)
                                        </option>
                                        <option data-countryCode="GB" value="+44">
                                            United Kingdom (+44)
                                        </option>
                                        <option data-countryCode="US" value="+1">
                                            United States (+1)
                                        </option>
                                        <option data-countryCode="UM" value="+1">
                                            United States Minor Outlying Islands (+1)
                                        </option>
                                        <option data-countryCode="UY" value="+598">
                                            Uruguay (+598)
                                        </option>
                                        <option data-countryCode="UZ" value="+998">
                                            Uzbekistan (+998)
                                        </option>
                                        <option data-countryCode="VU" value="+678">
                                            Vanuatu (+678)
                                        </option>
                                        <option data-countryCode="VA" value="+379">
                                            Vatican City State (Holy See) (+379)
                                        </option>
                                        <option data-countryCode="VE" value="+58">
                                            Venezuela (+58)
                                        </option>
                                        <option data-countryCode="VN" value="+84">
                                            Vietnam (+84)
                                        </option>
                                        <option data-countryCode="VG" value="+1-284">
                                            Virgin Islands (British) (+1-284)
                                        </option>
                                        <option data-countryCode="VI" value="+1-340">
                                            Virgin Islands (US) (+1-340)
                                        </option>
                                        <option data-countryCode="WF" value="+681">
                                            Wallis and Futuna Islands (+681)
                                        </option>
                                        <option data-countryCode="EH" value="+212">
                                            Western Sahara (+212)
                                        </option>
                                        <option data-countryCode="YE" value="+967">
                                            Yemen (+967)
                                        </option>
                                        <option data-countryCode="ZM" value="+260">
                                            Zambia (+260)
                                        </option>
                                        <option data-countryCode="ZW" value="+263">
                                            Zimbabwe (+263)
                                        </option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-9">
                                <input class="form-control contact contact-0" type="text"
                                    oninput="validateInput('0', 'india')" onchange="checkContact(this)"
                                    placeholder="Contact*" id="contact-0" name="contact" required />
                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4">
                        <div class="row">
                            <label for="state">State (mandatory)</label>
                            <div class="col-12">
                                <div class="select2-drop">
                                    <select class="form-select state state-0 select2" style="width: 100%;"
                                        aria-label="Default select example" id="state-0" name="state"
                                        onchange="setCities(this, 0);" required data-id="0">


                                        <option value=""> Select a State </option>
                                        <option value="Andaman and Nicobar Islands" data-state-id="1">
                                            Andaman and Nicobar Islands
                                        </option>
                                        <option value="Andhra Pradesh" data-state-id="2">
                                            Andhra Pradesh
                                        </option>
                                        <option value="Arunachal Pradesh" data-state-id="3">
                                            Arunachal Pradesh
                                        </option>
                                        <option value="Assam" data-state-id="4">
                                            Assam
                                        </option>
                                        <option value="Bihar" data-state-id="5">
                                            Bihar
                                        </option>
                                        <option value="Chandigarh" data-state-id="6">
                                            Chandigarh
                                        </option>
                                        <option value="Chhattisgarh" data-state-id="7">
                                            Chhattisgarh
                                        </option>
                                        <option value="Dadra and Nagar Haveli" data-state-id="8">
                                            Dadra and Nagar Haveli
                                        </option>
                                        <option value="Daman and Diu" data-state-id="9">
                                            Daman and Diu
                                        </option>
                                        <option value="Delhi" data-state-id="10">
                                            Delhi
                                        </option>
                                        <option value="Goa" data-state-id="11">
                                            Goa
                                        </option>
                                        <option value="Gujarat" data-state-id="12">
                                            Gujarat
                                        </option>
                                        <option value="Haryana" data-state-id="13">
                                            Haryana
                                        </option>
                                        <option value="Himachal Pradesh" data-state-id="14">
                                            Himachal Pradesh
                                        </option>
                                        <option value="Jammu and Kashmir" data-state-id="15">
                                            Jammu and Kashmir
                                        </option>
                                        <option value="Jharkhand" data-state-id="16">
                                            Jharkhand
                                        </option>
                                        <option value="Karnataka" data-state-id="17">
                                            Karnataka
                                        </option>
                                        <option value="Kerala" data-state-id="18">
                                            Kerala
                                        </option>
                                        <option value="Ladakh" data-state-id="19">
                                            Ladakh
                                        </option>
                                        <option value="Lakshadweep" data-state-id="20">
                                            Lakshadweep
                                        </option>
                                        <option value="Madhya Pradesh" data-state-id="21">
                                            Madhya Pradesh
                                        </option>
                                        <option value="Maharashtra" data-state-id="22">
                                            Maharashtra
                                        </option>
                                        <option value="Manipur" data-state-id="23">
                                            Manipur
                                        </option>
                                        <option value="Meghalaya" data-state-id="24">
                                            Meghalaya
                                        </option>
                                        <option value="Mizoram" data-state-id="25">
                                            Mizoram
                                        </option>
                                        <option value="Nagaland" data-state-id="26">
                                            Nagaland
                                        </option>
                                        <option value="Narora" data-state-id="27">
                                            Narora
                                        </option>
                                        <option value="Odisha" data-state-id="28">
                                            Odisha
                                        </option>
                                        <option value="Pondicherry" data-state-id="29">
                                            Pondicherry
                                        </option>
                                        <option value="Punjab" data-state-id="30">
                                            Punjab
                                        </option>
                                        <option value="Rajasthan" data-state-id="31">
                                            Rajasthan
                                        </option>
                                        <option value="Sikkim" data-state-id="32" selected>
                                            Sikkim
                                        </option>
                                        <option value="Tamil Nadu" data-state-id="33">
                                            Tamil Nadu
                                        </option>
                                        <option value="Telangana" data-state-id="34">
                                            Telangana
                                        </option>
                                        <option value="Tripura" data-state-id="35">
                                            Tripura
                                        </option>
                                        <option value="Uttar Pradesh" data-state-id="36">
                                            Uttar Pradesh
                                        </option>
                                        <option value="Uttarakhand" data-state-id="37">
                                            Uttarakhand
                                        </option>
                                        <option value="West Bengal" data-state-id="38">
                                            West Bengal
                                        </option>
                                        <option value="state" data-state-id="39">
                                            state
                                        </option>
                                        <option value="divya" data-state-id="40">
                                            divya
                                        </option>
                                        <option value="dddwdww" data-state-id="41">
                                            dddwdww
                                        </option>
                                        <option value="Dadra and Nagar Haveli and Daman and Diu" data-state-id="1672">
                                            Dadra and Nagar Haveli and Daman and Diu
                                        </option>
                                        <option value="Puducherry" data-state-id="1673">
                                            Puducherry
                                        </option>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4">
                        <div class="row">
                            <label for="city">City (mandatory)</label>
                            <div class="col-12">
                                <div class="select2-drop">
                                    <select class="form-select city city-0 select2" style="width: 100%;"
                                        aria-label="Default select example" id="city-0" name="city" required
                                        data-id="0">


                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4">
                        <div class="row">
                            <label for="drop">DROP</label>
                            <div class="col-12">
                                <div class="select2-drop">
                                    <select class="form-select drop drop-0 select2" style="width: 100%;"
                                        aria-label="Default select example" id="drop-0" name="drop" required
                                        data-id="0">


                                        <option value="val 1">
                                            val 1
                                        <option value="val 2">
                                            val 2
                                        <option value="val 3">
                                            val 3
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4 chapter">
                        <div class="row">
                            <label for="chapter">chapter</label>
                            <div class="col-12">
                                <input class="form-control chapter chapter-0" type="text" placeholder="1"
                                    value="chapter" id="chapter-0" name="chapter" />

                            </div>
                        </div>
                    </div>
                    <div class="form-group pt-4 select2-drop hotel-booking-dropdown">
                        <div class="row">
                            <div class="col-12">
                                <label class="form-label" for="hotel_booking_id">Hotel Booking</label>
                                <select class="form-select" name="hotel_booking_id" id="hotel_booking_id"
                                    data-placeholder="Select Hotel">
                                    <option value="">Select Hotel</option>
                                    <option value="1">H1</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="row form-group pt-4">
                        <div class="col-md-4"></div>
                        <button type="submit" class="gst_number-7 btn col-md-3 btn btn-warning btn-sm">Register
                        </button>
                        <div class="col-md-4"></div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        function designationSelect(value) {
            $(".Other").css("display", "none");
            $(".form-control.Other").attr("required", false);
            $(".form-control.Other").val("");
            if (value == "Other") {
                $(".Other").css("display", "block");
                $(".form-control.Other").attr("required", true);
            }
        }

        function onlyNumberKey(evt) {
            console.log("Key Code:", evt.keyCode)
            // Only ASCII character in that range allowed
            var ASCIICode = (evt.which) ? evt.which : evt.keyCode
            if (ASCIICode > 31 && (ASCIICode < 48 || ASCIICode > 57))
                return false;
            return true;
        }

        function validateInput(id, countryCode = 'india') {
            let input = document.getElementById("contact-" + id);
            let contactValue = input.value.replace(/[^\d ]/g, '');
            let value = contactValue.replace(/\s/g, "");
            console.log(value);
            // let formattedValue = "";
            // if (countryCode === 'india') { // India
            //     if (value.length > 10) {
            //         formattedValue = value.slice(0, 10);
            //     } else {
            //         formattedValue = value;
            //     }
            // } else if (countryCode === 'Uganda') { // Uganda
            //     if (value.length > 9) {
            //         formattedValue = value.slice(0, 9);
            //     } else {
            //         formattedValue = value;
            //     }
            // } else {
            //     formattedValue = value;
            // }
            $("#contact-" + id).val(value);

            // $.ajaxSetup({
            //     headers: {
            //         'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            //     }
            // });
            // $.ajax({
            //     url: "http://grid.local/check-user",
            //     type: "post",
            //     data: {
            //         "_token": "cjLGwg1DZhF90GK80HBUe8dsSiwHl9W6mT9fvwEk",
            //         contact: formattedValue,
            //     },
            //     success: function(data) {
            //         $(".loader_contact").html('');
            //         if (data.status == true) {
            //             $(".name-" + id).val(data.name);
            //             $(".state-" + id + " option[value='" + data.state + "']").attr('selected', 'selected');
            //             let emailVal = data.email.replace(/\s/g, "");
            //             let value = emailVal.toLowerCase();
            //             $(".email-" + id).val(value);
            //             $("#select_city").val(data.city);
            //             if ($(".state-" + id).val() != "") {
            //                 setCities(data.state, id)
            //             }
            //         } else {
            //             $(".name-" + id).val("");
            //             $(".email-" + id).val("");
            //             $("#select_city").val("");
            //         }
            //     }
            // });
        }

        function validateEmail(id) {
            let input = document.getElementById("email-" + id);
            let email = input.value.replace(/\s/g, "");
            let value = email.toLowerCase();
            $("#email-" + id).val(value);
        }


        $(document).ready(function() {
            if ($("#select_state").val() != "") {
                $(".state").trigger('change');
            }
            $(".custom-validation").parsley();
            $('.custom-validation').submit(function() {
                if ($(this).parsley().isValid()) {
                    $(this).find(':submit').attr('disabled', true);
                }
            });
            var checkedForm = $('.event_form_class:checked').attr('data-label');
            if (checkedForm) {
                checkedForm = checkedForm.replaceAll(" ", "_").toLowerCase();
                $('.' + checkedForm).css("display", 'block');
            }
        });
        $('.event_form_class').change(function() {
            $('.event_form_div').css('display', 'none');
            var checkedForm = $(this).attr('data-label');
            checkedForm = checkedForm.replaceAll(" ", "_").toLowerCase();
            $('.' + checkedForm).css("display", 'block');
        })

        function updateStates(keyId) {
            var countrySelect = document.getElementById("countrySelect-" + keyId);
            var selectedOption = countrySelect.options[countrySelect.selectedIndex];
            var countryCode = selectedOption.getAttribute('data-countryCode');
            var stateSelect = document.querySelector(".state-" + keyId);
            stateSelect.innerHTML = "";
            var defaultOption = document.createElement("option");
            defaultOption.value = "";
            defaultOption.textContent = "Select a state";
            stateSelect.appendChild(defaultOption);

            $(".city-" + keyId).val("").html("<option value=''>Select a city</option>");
            var url = 'http://grid.local/states-ajax/:selectedCountryName'.replace(':selectedCountryName',
                countryCode);

            fetch(url)
                .then(response => {
                    console.log('Fetch Response:', response);
                    if (!response.ok) {
                        throw new Error('Failed to fetch states');
                    }
                    return response.json();
                })
                .then(states => {
                    var stateSelect = document.querySelector(".state-" + keyId);

                    states.forEach(state => {
                        var option = document.createElement("option");
                        option.value = state.state_name;
                        option.dataset.stateId = state.id;
                        option.textContent = state.state_name;
                        stateSelect.appendChild(option);
                    });
                    $(".state-" + keyId).val($("#select_state").val()).trigger("change");
                    console.log("Selected Country:", countryCode);
                })
                .catch(error => {
                    console.error('Error fetching states:', error);
                });
        }

        function setCities(value, keyId) {
            var value = $('#' + value.id).find('option[value="' + value.value + '"]');
            var value = value.data('state-id');

            if (!value) {
                var options = `<option value="" selected>Select a city</option>`;
                $('.city-' + keyId).html(options);
                $('#select_city').prop('disabled', true);
                return;
            }
            var selectedCity = $("#select_city").val();
            var url = 'http://grid.local/cities-ajax/:state';
            url = url.replace(':state', value);
            const xhttp = new XMLHttpRequest();
            xhttp.open("GET", url, false);
            xhttp.send();
            const res = xhttp.responseText
            const cities = JSON.parse(res)
            var options = `<option value="" selected>Select a city</option>`
            for (let i = 0; i < cities.length; i++) {
                const city = cities[i];
                if (selectedCity == city["city_name"]) {
                    options = options + `<option value="${city["city_name"]}" selected>${city["city_name"]}</option>`
                } else {
                    options = options + `<option value="${city["city_name"]}">${city["city_name"]}</option>`
                }
            }
            $('.city-' + keyId).html(options);
        }

        var $modal = $('#cropImageModal');
        var image = document.getElementById('uploadedImage');
        var cropper;
        var input;
        var imageExt;

        $('.business_photo').change(function(event) {
            console.log("Business pic change.")
            imageModel(this, event);
        });

        $('.profile_photo').change(function(event) {
            console.log("Profile pic change.")
            imageModel(this, event);
        });

        $('.about_conclave-0').change(function(event) {
            const aboutConclave = $(this).val();
            console.log("About Conclave:", aboutConclave)

            if (aboutConclave === 'BNI Member' || aboutConclave === 'Friend or Associate') {
                $('.referrer_name-0').prop('required', true)
            } else {
                $('.referrer_name-0').prop('required', false)
            }
        })

        $modal.on('shown.bs.modal', function() {
            cropper = new Cropper(image, {
                aspectRatio: 1,
                viewMode: 1,
            });
        }).on('hidden.bs.modal', function() {
            cropper.destroy();
        });

        $('#crop_submit').click(function() {
            var canvas = cropper.getCroppedCanvas({
                width: 500,
                height: 500
            });

            cropper.getCroppedCanvas().toBlob(function(blob) {
                let file = new File(
                    [blob],
                    "crop-" + input.id + "." + imageExt, {
                        type: blob.type,
                        lastModified: new Date().getTime()
                    }
                );
                let container = new DataTransfer();
                container.items.add(file);
                input.files = container.files;
                $($modal).modal('hide');
                cropper.destroy();
            }, "image/jpeg");
        });

        function imageModel(ele, event) {
            input = ele;
            const files = event.target.files;
            imageExt = files[0].type.split("/")[1];
            const allowExt = [
                'image/jpeg',
                'image/jpg',
                'image/png'
            ]
            if (allowExt.indexOf(files[0].type) !== -1) {
                const done = function(url) {
                    image.src = url;
                    $modal.modal('show');
                };

                if (files && files.length > 0) {
                    let reader = new FileReader();
                    reader.onload = function(event) {
                        done(reader.result);
                    };
                    reader.readAsDataURL(files[0]);
                }
            }
        }
    </script>

    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=UA-205937290-1"></script>

    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', 'UA-205937290-1');
    </script>

    <!-- Global site tag (gtag.js) - Google Ads -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=AW-10800048870"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', 'AW-10800048870');
    </script>

    <script>
        $(document).ready(function() {
            $(".select2").select2();


            // hide show hotel dropdown end
        });
    </script>
    <script>
        $(".alert").fadeTo(4000, 4000).slideUp(2000, function() {
            $(".alert").slideUp(4000);
        });
    </script>

</body>

</html>
